#include "MacLib.h"

// C = A*B macierzowo
void razy(int *nC,int *mC,double C[][mMax],\
     int nA,int mA,double A[][mMax],\
     int nB,int mB,double B[][mMax])
{
   int i,j,k;

   if( mA!=nB )
   {
      puts("ERROR: zle wymiary macierzy !?");
      getchar();
      exit(-1);
   }
   *nC = nA;
   *mC = mB;
   for(i=0 ; i<*nC ; i=i+1)
   {
      for(j=0 ; j<*mC ; j=j+1)
      {
         C[i][j] = 0.0;
         for( k=0 ; k<mA ; k=k+1)
         {
            C[i][j] = C[i][j]+A[i][k]*B[k][j];
         }
      }
   }
}
//---------------------------------------------------------------------------

// wyswietla na ekranie macierz A
void wyswietl(int n,int m,double A[][mMax])
{
   int i,j;

   for(i=0 ; i<n ; i=i+1)
   {
      for(j=0 ; j<m ; j=j+1)
      {
         printf("%10.4lf ",A[i][j]);
      }
      printf("\n");
   }
}
//---------------------------------------------------------------------------

int main(int argc, char *argv[])
{
   double A1[nMax][mMax],A2[nMax][mMax],W[nMax][mMax];
   int m1,n1,m2,n2,mW,nW;

   if( argc!=4 )
   {
      puts("ERROR: zla ilosc parametrow !?");
      getchar();
      exit(-1);
   }      
   weMac(&n1,&m1,A1, argv[1]);
   weMac(&n2,&m2,A2, argv[2]);
   razy(&nW,&mW,W, n1,m1,A1, n2,m2,A2);
   wyMac(nW,mW,W, argv[3]); 
   wyswietl(n1,m1,A1);
   puts("x");
   wyswietl(n2,m2,A2);
   puts("=");
   wyswietl(nW,mW,W);
   puts("");
   puts("wykonalem");
   getchar();	
   return 0;
}
