#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <gmp.h>
#include <time.h>
#include <sys/time.h>
#include <sys/types.h>
#include <sys/resource.h>


#include "PrimeQ64.h"
//#include "PrimeQ32.h" 
// choose 64 or 32 bit version above

long long
microtime()
{
        struct timeval start;
        long long wynik;

        gettimeofday( &start, NULL );
        wynik = start.tv_sec * 1000000LL + start.tv_usec;
        return wynik;
}

long long mytime, totaltime;



// below you define what action to take when a solution is found
void ReportSolution(int AP_Length,int difference,long long First_Term){
  if(AP_Length>=15){
    FILE *out;
    out = fopen("SOL-AP19.TXT", "a");
    fprintf(out,"%d %d %lld\n",AP_Length,difference,First_Term);
    fclose(out);
  }
};



#include "AP19.h"



int main(int argc, char *argv[])
{ 
	  	FILE *in, *out;
	  	int K, KMIN, KMAX, shift;
	  	
	  	
	  	  mytime = microtime();


if(argc!=4){
	in = fopen("AP19-ini.txt", "r");
	if(NULL == in){
		printf("Cannot read AP19-ini.txt !!!\n");
		exit(0);
	} else {
		fscanf(in,"%d %d %d\n",&KMIN,&KMAX,&shift);
		fclose(in);
	}
}else{
sscanf(argv[1],"%d",&KMIN);
sscanf(argv[2],"%d",&KMAX);
sscanf(argv[3],"%d",&shift);
}

	out = fopen("AP19-ini.txt", "w");
	if(NULL == out){
		printf("Cannot write AP19-ini.txt !!!\n");
		exit(0);
	} else {
		fprintf(out,"%d %d %d\n",KMIN,KMAX,shift);
		fclose(out);
	}

for(K=KMIN;K<=KMAX;K+=1){
    SearchAP19(K,shift);
    
	out = fopen("AP19-ini.txt", "w");
	if(NULL == out){
		printf("Cannot write AP19-ini.txt !!!\n");
		exit(0);
	} else {
		fprintf(out,"%d %d %d\n",K+1,KMAX,shift);
		fclose(out);
	}
}


    totaltime=microtime()-mytime;
    printf("TIME: %lld microseconds\n",totaltime);

  return 0;
}


